////////////////////////////////////////////////////////////////////////////////////////////
// Welcome to nHTMLn 2.9, curious stranger
////////////////////////////////////////////////////////////////////////////////////////////

#include <stdarg.h>
#define WIN32_LEAN_AND_MEAN
#define WINVER 0x0400
#define _X86_
#include <windef.h>
#include <winbase.h>
#include <objbase.h>
#include <exdisp.h>
#include <exdispid.h>

//#define mb(x) MessageBox(0,x,"nHTMLn",0)


////////////////////////////////////////////////////////////////////////////////////////////
// declarations
////////////////////////////////////////////////////////////////////////////////////////////

typedef struct	//mIRC passes this structure to the 'LoadDll' function
{
	DWORD  mVersion;
	HWND   mHwnd;
	BOOL   mKeep;
} LOADINFO;

#define ret(x) { lstrcpy(data,x); return 3; }		//ugly yet useful
#define WM_EVALUATE	((WM_USER) + 201)

//error and success codes
#define E_INVALID_WINDOW		"E_INVALID_WINDOW"
#define E_FAILED				"E_FAILED"
#define E_NOT_FOUND				"E_NOT_FOUND"
#define E_ALREADY_ATTACHED		"E_ALREADY_ATTACHED"
#define E_NOT_READY				"E_NOT_READY"
#define E_INVALID_MARGINS		"E_INVALID_MARGINS"
#define E_INVALID_CURSOR		"E_INVALID_CURSOR"
#define E_INVALID_ID			"E_INVALID_ID"
#define SCANCEL					"S_CANCEL"
#define SFALSE					"S_FALSE"
#define STRUE					"S_TRUE"
#define SOK						"S_OK"

#define TRY(x) && SUCCEEDED(x)						//even uglier
#define RELEASE(ptr) if (ptr) ptr->Release()

//COM object, acts ActiveX container for WebBrowser control
class Browser : public IOleClientSite, public IOleInPlaceSite, public DWebBrowserEvents2
{
public:
	
	//WebBrowser interface pointers
	IOleInPlaceObject			*pOleInPlaceObject;
	IWebBrowser2				*pWebBrowser2;
	IOleObject					*pOleObject;
	IConnectionPointContainer	*pCPC;
	IConnectionPoint			*pCP;
	
	DWORD cookie;								//for IConnectionPoint::Advise
	
	//parent window
	WNDPROC						old_wnd_proc;	//old window procedure
	HWND						parent;			//parent window HWND
	
	char alias[1024];							//mIRC event handler
	
	//margins
	RECT margins;
	
	Browser(HWND,WNDPROC);		//ctor
	~Browser();					//dtor
	
	VARIANT_BOOL Browser::deliver(LPSTR event,BSTR bstr);	//for events
	
	//IDispatch
    HRESULT STDMETHODCALLTYPE GetTypeInfoCount(UINT __RPC_FAR *pctinfo) { *pctinfo = 0; return S_OK; }
    HRESULT STDMETHODCALLTYPE GetTypeInfo(UINT,LCID,ITypeInfo __RPC_FAR *__RPC_FAR*) { return E_NOTIMPL; }
    HRESULT STDMETHODCALLTYPE GetIDsOfNames(REFIID,LPOLESTR __RPC_FAR*,UINT,LCID,DISPID __RPC_FAR*) { return E_NOTIMPL; }        
	HRESULT STDMETHODCALLTYPE Invoke(DISPID,REFIID,LCID,WORD,DISPPARAMS __RPC_FAR *,VARIANT __RPC_FAR *,EXCEPINFO __RPC_FAR *,UINT __RPC_FAR *);	
	
	//IOleClientSite
	HRESULT STDMETHODCALLTYPE SaveObject() { return S_OK; }
	HRESULT STDMETHODCALLTYPE GetMoniker(DWORD,DWORD,IMoniker __RPC_FAR *__RPC_FAR*) { return E_NOTIMPL; }
	HRESULT STDMETHODCALLTYPE GetContainer(IOleContainer __RPC_FAR *__RPC_FAR*) { return E_NOTIMPL; }
	HRESULT STDMETHODCALLTYPE ShowObject() { return S_OK; }
	HRESULT STDMETHODCALLTYPE OnShowWindow(BOOL) { return S_OK; }
	HRESULT STDMETHODCALLTYPE RequestNewObjectLayout() { return S_OK; }
	
	//IOleInPlaceSite
	HRESULT STDMETHODCALLTYPE CanInPlaceActivate() { return S_OK; }
	HRESULT STDMETHODCALLTYPE OnInPlaceActivate() { return S_OK; };
	HRESULT STDMETHODCALLTYPE OnUIActivate() { return S_OK; }
    HRESULT STDMETHODCALLTYPE Scroll(SIZE) { return E_NOTIMPL; }
	HRESULT STDMETHODCALLTYPE OnUIDeactivate(BOOL) { return S_OK; }
	HRESULT STDMETHODCALLTYPE OnInPlaceDeactivate() { return S_OK; }
	HRESULT STDMETHODCALLTYPE DiscardUndoState() { return S_OK; }
	HRESULT STDMETHODCALLTYPE DeactivateAndUndo() { return S_OK; }
	HRESULT STDMETHODCALLTYPE OnPosRectChange(LPCRECT) { return S_OK; }
	HRESULT STDMETHODCALLTYPE GetWindowContext(IOleInPlaceFrame __RPC_FAR *__RPC_FAR*,IOleInPlaceUIWindow __RPC_FAR *__RPC_FAR*,LPRECT,LPRECT,LPOLEINPLACEFRAMEINFO);        
	
	//IOleWindow
	HRESULT STDMETHODCALLTYPE GetWindow(HWND __RPC_FAR *phwnd) { *phwnd = parent; return S_OK; }
	HRESULT STDMETHODCALLTYPE ContextSensitiveHelp(BOOL) { return E_NOTIMPL; }
	
	//IUnknown
    ULONG STDMETHODCALLTYPE AddRef() { return 2; }
	ULONG STDMETHODCALLTYPE Release() { return 8; }
	HRESULT STDMETHODCALLTYPE QueryInterface(REFIID, __RPC_FAR void* __RPC_FAR*);
};

////////////////////////////////////////////////////////////////////////////////////////////
// global variables
////////////////////////////////////////////////////////////////////////////////////////////


Browser			**browsers;				//list of pointers to browsers
HWND			sel_wnd;				//default browser
IClassFactory	*pClassFactory;			//WebBrowser class factory
HWND			mWnd;					//mIRC main window
LPSTR			mData;					//file mapped memory
HANDLE			hFileMap;				//file mapping object
LPSTR			findstr;				//local char[] in 'find'
LPVOID heap;							//process heap
int cnt;								//number of browsers

////////////////////////////////////////////////////////////////////////////////////////////
// Minimal CRT
////////////////////////////////////////////////////////////////////////////////////////////

extern int __cdecl _purecall() { return 0; }
extern "C" BOOL WINAPI _DllMainCRTStartup(HANDLE hDllHandle, DWORD dwReason, LPVOID lpReserved)
{
	heap = GetProcessHeap();
	return TRUE;
}
void* __cdecl operator new(size_t n)
{
	return HeapAlloc(heap,HEAP_ZERO_MEMORY,n);
}
void __cdecl operator delete(void* p)
{
	if (p) HeapFree(heap,0,p);
}
void fr(void *p)
{
	if (p) HeapFree(heap,0,p);
}
void* rlc(void *p,size_t n)
{
	if (n) return p ? HeapReAlloc(heap,HEAP_ZERO_MEMORY,p,n) : HeapAlloc(heap,HEAP_ZERO_MEMORY,n);
	fr(p);
	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////
// internal functions
////////////////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------------------
BOOL whitespace(char c)
{
	return (c < 'a' || c > 'z')
		&& (c < '0' || c > '9')
		&& (c < 'A' ||  c > 'Z')
		&& (c != '-') && c;
}

//------------------------------------------------------------------------------------------
void get_token(char *dest,char*&src)
{
	while (whitespace(*src)) src++;
	while (*src && !whitespace(*src)) *dest++ = *src++; 
	*dest = 0;
}

//------------------------------------------------------------------------------------------
//int <--> char*
void ltoa(char *data,int value) { wsprintf(data,"%d",value); }
int atol(char *data)
{
	int result = 0, sign = 1;
	if (*data == '-') { sign = -1; data++; }
	while (*data >= '0' && *data <= '9') { result *= 10; result += (*data++ - '0'); }
	return result * sign;
}

//------------------------------------------------------------------------------------------
//substract margins from client rectangle
#pragma optimize ( "t", on )
__forceinline void reduce_rect(RECT *dest,RECT *src)
{
	(*dest).left = (*src).left;
	(*dest).top = (*src).top;
	(*dest).right -= (*src).right;
	(*dest).bottom -= (*src).bottom;
}

//------------------------------------------------------------------------------------------
//simple insertion sort
void sort_browsers()
{
	Browser **end = browsers + cnt, **a = end, **b, *ptr;
	HWND parent;
	while (a > browsers)
	{
		parent = (*--a)->parent;
		for (b = end; --b > a;)
			if ((*b)->parent < parent) { ptr = *a; *a = *b; *b = ptr; }
	}
}


//------------------------------------------------------------------------------------------
//find browser index by HWND, 0 if failed
int find_browser(HWND parent)
{
	int left = 0, right = cnt, mid;
	HWND element;
	while(left < right)
	{
		mid = (left + right) >> 1;
		element = browsers[mid]->parent;
		if (parent == element) return mid;
		if (parent < element) right = mid; else (left = mid)++;
	}
	return -1;
}
#pragma optimize ( "t", off )

//------------------------------------------------------------------------------------------
//find browser by (HWND)string, 0 if failed
int find_browser(LPSTR data)
{
	HWND window = (HWND)atol(data);
	if (!IsWindow(window)) window = sel_wnd;
	return find_browser(window);	
}


//------------------------------------------------------------------------------------------
void detach_browser(int i)
{
	delete browsers[i];
	browsers[i] = browsers[--cnt];
	browsers = (Browser**)rlc(browsers,sizeof(Browser*) * cnt);
	sort_browsers();
}

//------------------------------------------------------------------------------------------
//subclass window procedure
#pragma optimize ( "t", on )
LRESULT CALLBACK subclass_wnd_proc(HWND hwnd,UINT msg,WPARAM wp,LPARAM lp)
{
	int i = find_browser(hwnd);
	if (i >= 0)
	{
		Browser *pb = browsers[i];
		WNDPROC old_proc = pb->old_wnd_proc;
		
		switch(msg)
		{
		case WM_SIZE:			//adjust browser size
			RECT rc; GetClientRect(hwnd,&rc);
			reduce_rect(&rc,&pb->margins);
			pb->pOleInPlaceObject->SetObjectRects(&rc,&rc);
			break;
		case WM_DESTROY:
			detach_browser(i);
		}
		return CallWindowProc(old_proc,hwnd,msg,wp,lp);
	}
	return 0; //should never be here
}

//------------------------------------------------------------------------------------------
//search for child windows, LPARAM is where to write HWND
BOOL CALLBACK enum_children(HWND hWnd,LPARAM lp)
{
	char caption[4096];
	GetWindowText(hWnd,caption,4095);
	if (lstrcmp(findstr,caption)) return TRUE;
	ltoa((char*)lp,(int)hWnd);
	return FALSE;
}
#pragma optimize ( "t", off )

//------------------------------------------------------------------------------------------
//execute DHTML command, used by 'print' and 'zoom'
int exec_cmd(LPSTR data,DWORD cmd_id,VARIANT *inp_args)
{
	int i = find_browser(data);
	if (i >= 0) 
	{
		IDispatch *pDispatch;
		IOleCommandTarget *pOCT;
		
		//determine if document is ready
		READYSTATE ready_state;
		if (FAILED(browsers[i]->pWebBrowser2->get_ReadyState(&ready_state)))
			ret(E_FAILED);
		if (ready_state != READYSTATE_COMPLETE)	ret(E_NOT_READY);
		
		//obtain document
		if(SUCCEEDED(browsers[i]->pWebBrowser2->get_Document(&pDispatch)))
		{
			//get IOleCommandTarget*
			if(SUCCEEDED(pDispatch->QueryInterface(IID_IOleCommandTarget,(void**)&pOCT)))
			{
				//execute command
				if(SUCCEEDED(pOCT->Exec(0,cmd_id,0,inp_args,0)))
				{
					pOCT->Release();
					pDispatch->Release();
					ret(SOK);
				}
				pOCT->Release();
			}
			pDispatch->Release();
		}
		ret(E_FAILED);
	}
	ret(E_INVALID_WINDOW);
}

////////////////////////////////////////////////////////////////////////////////////////////
// Browser member functions
////////////////////////////////////////////////////////////////////////////////////////////

//------------------------------------------------------------------------------------------
Browser::Browser(HWND parent,WNDPROC new_wnd_proc)
{
	this->parent = parent;
	RECT rc;
	GetClientRect(parent,&rc);
	
	if(pClassFactory	
		TRY(pClassFactory->CreateInstance(0,IID_IWebBrowser2,(void**)&pWebBrowser2))
		TRY(pWebBrowser2->QueryInterface(IID_IOleObject,(LPVOID*)&pOleObject))
		TRY(pWebBrowser2->QueryInterface(IID_IOleInPlaceObject,(LPVOID*)&pOleInPlaceObject))
		TRY(pWebBrowser2->QueryInterface(IID_IConnectionPointContainer,(LPVOID*)&pCPC))
		TRY(pOleObject->SetClientSite((IOleClientSite*)this))
		TRY(pCPC->FindConnectionPoint(DIID_DWebBrowserEvents2,&pCP))
		TRY(pCP->Advise((IUnknown*)(IOleClientSite*)this,&cookie))
		TRY(pOleObject->DoVerb(OLEIVERB_INPLACEACTIVATE,0,(IOleClientSite*)this,0,parent,&rc))
		)
	{ 
		//subclass parent window
		old_wnd_proc = (WNDPROC)SetWindowLong(parent,GWL_WNDPROC,(LONG)new_wnd_proc);
	}
}

//------------------------------------------------------------------------------------------
Browser::~Browser()
{
	//release interface pointers, etc.
	if (cookie) pCP->Unadvise(cookie);
	RELEASE(pCP);
	RELEASE(pCPC);
	RELEASE(pOleInPlaceObject);
	if (pOleObject) { pOleObject->Close(OLECLOSE_NOSAVE); }
	RELEASE(pOleObject);
	RELEASE(pWebBrowser2);
	
	//unsubclass parent window
	if (old_wnd_proc) SetWindowLong(parent,GWL_WNDPROC,(LONG)old_wnd_proc);
}

//------------------------------------------------------------------------------------------
HRESULT STDMETHODCALLTYPE Browser::GetWindowContext(IOleInPlaceFrame __RPC_FAR *__RPC_FAR *ppFrame,IOleInPlaceUIWindow __RPC_FAR *__RPC_FAR *ppDoc,LPRECT pPR,LPRECT pCR,LPOLEINPLACEFRAMEINFO pFI)
{
	*ppFrame = 0;
	*ppDoc = 0;
	
	//set client area (updated in subclass_wnd_proc)
	GetClientRect(parent,pPR);
	reduce_rect(pPR,&margins);
	*pCR = *pPR;
	
	return S_OK;
}

//------------------------------------------------------------------------------------------
//deliver HTML event
VARIANT_BOOL Browser::deliver(LPSTR event,BSTR bstr)
{
	if (*alias)
	{
		//evaluate $alias(hwnd,event [ ,bstr ] )
		if (bstr && *bstr)
			wsprintf(mData,"$%s(%d,%s,%ws)",alias,parent,event,bstr);
		else
			wsprintf(mData,"$%s(%d,%s)",alias,parent,event);
		
		//call mIRC
		SendMessage(mWnd,WM_EVALUATE,0,0);
		
		//analyze result
		if (!lstrcmp(SCANCEL,mData))	return VARIANT_TRUE;
		if (*mData != 'S')				*alias = 0;
	}
	return VARIANT_FALSE;
}

//------------------------------------------------------------------------------------------
HRESULT Browser::Invoke(DISPID dispIdMember,REFIID riid,LCID lcid,WORD wFlags,DISPPARAMS __RPC_FAR *pDispParams,VARIANT __RPC_FAR *pVarResult,EXCEPINFO __RPC_FAR *pExcepInfo,UINT __RPC_FAR *puArgErr)
{
	char mbuf[4096];	//8192 fails with minimal CRT
	UINT err;
	VARIANT arg1,arg2;
	VariantInit(&arg1);
	VariantInit(&arg2);
	DispGetParam(pDispParams,0,VT_BSTR,&arg1,&err);
	DispGetParam(pDispParams,1,VT_BSTR,&arg2,&err);
	
	switch (dispIdMember)
	{
	case DISPID_NAVIGATECOMPLETE2:
		deliver("navigate_complete",arg2.bstrVal);
		break;
	case DISPID_BEFORENAVIGATE2:
		*pDispParams->rgvarg->pboolVal = deliver("navigate_begin",arg2.bstrVal);
		break;
	case DISPID_DOCUMENTCOMPLETE:
		deliver("document_complete",arg2.bstrVal);
		break;    
	case DISPID_DOWNLOADBEGIN:
		deliver("download_begin",0);
		break;
	case DISPID_DOWNLOADCOMPLETE:
		deliver("download_complete",0);
		break;
	case DISPID_NEWWINDOW2:
		*pDispParams->rgvarg->pboolVal = deliver("window_open",0);
		break;
	case DISPID_STATUSTEXTCHANGE:
		deliver("status_change",arg1.bstrVal);
		break;
	case DISPID_TITLECHANGE:
		deliver("title_change",arg1.bstrVal);
		break;
	case DISPID_PROGRESSCHANGE:
		wsprintf(mbuf,"progress_change %ls of %ls",arg1.bstrVal,arg2.bstrVal);
		deliver(mbuf,0);
		break;
	case DISPID_COMMANDSTATECHANGE:
		switch(*arg1.bstrVal)
		{
		case L'1':
			wsprintf(mbuf,"state_change forward:%s",arg2.boolVal ? "enabled" : "disabled");
			deliver(mbuf,0);
			break;
		case L'2':
			wsprintf(mbuf,"state_change back:%s",arg2.boolVal ? "enabled" : "disabled");
			deliver(mbuf,0);
		}
	}
	VariantClear(&arg1);
	VariantClear(&arg2);
	return S_OK;
}

//------------------------------------------------------------------------------------------
HRESULT STDMETHODCALLTYPE Browser::QueryInterface(REFIID riid,void __RPC_FAR *__RPC_FAR *ppvObject)
{
	*ppvObject = 0;
	
	if (IID_IUnknown == riid)			{ *ppvObject = (IUnknown*)(IOleClientSite*)this; }
	if (IID_IOleInPlaceSite == riid)	{ *ppvObject = (IOleInPlaceSite*)this; }
	if (DIID_DWebBrowserEvents2 == riid){ *ppvObject = (DWebBrowserEvents2*)this; }
	
	return *ppvObject ? S_OK : E_NOINTERFACE;
}

////////////////////////////////////////////////////////////////////////////////////////////
// mIRC functions
////////////////////////////////////////////////////////////////////////////////////////////


extern "C"
{
	//------------------------------------------------------------------------------------------
	//attach browser to window
	int WINAPI attach(HWND mWnd,HWND,char *data,char*,BOOL,BOOL)
	{
		HWND window = (HWND)atol(data);
		if (IsWindow(window) && window != mWnd)
		{
			if (find_browser(window) >= 0) ret(E_ALREADY_ATTACHED);
			
			browsers = (Browser**)rlc(browsers,sizeof(Browser*) * (cnt + 1));
			browsers[cnt] = new Browser(window,subclass_wnd_proc);
			if (!(browsers[cnt]->old_wnd_proc))
			{
				delete browsers[cnt];
				ret(E_FAILED);
			}
			cnt++;
			sort_browsers();		
			sel_wnd = window;
			ret(SOK);
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//detach browser from window
	int WINAPI detach(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0)
		{
			detach_browser(i);
			ret(SOK);
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//select default browser
	int WINAPI select(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0)
		{
			sel_wnd = browsers[i]->parent;
			ret(SOK);
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//return HWND of default browser
	int WINAPI selected(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		ltoa(data,(int)sel_wnd);
		return 3;
	}
	
	//------------------------------------------------------------------------------------------
	//navigate to URL
	int WINAPI navigate(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(sel_wnd);
		if (i >= 0)
		{
			OLECHAR url[4096];
			MultiByteToWideChar(CP_ACP,0,data,-1,url,4095);			
			VARIANT v;
			VariantInit(&v);			
			ret(SUCCEEDED(browsers[i]->pWebBrowser2->Navigate(url,&v,&v,&v,&v)) ? SOK : E_FAILED);
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//set handler
	int WINAPI handler(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(sel_wnd);
		if (i >= 0)
		{
			lstrcpy(browsers[i]->alias,data);
			ret(SOK);
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//set margins
	int WINAPI margins(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(sel_wnd);
		if (i >= 0)
		{
			long *target = 0, all = TRUE;
			Browser *pb = browsers[i];
			RECT client = pb->margins;
			char token[1024], *d = data;
			
			do
			{
				get_token(token,d);
				if (*token == '-' || (*token >= '0' && *token <= '9'))	//is it numeric?
				{
					int v = atol(token);
					if (target)
					{
						*target = v;
						all = FALSE;
						target = 0;
					}
					else
					{
						if (all) 
						{
							client.top = v; client.right = v; client.left = v; client.bottom = v;
							all = FALSE;
						}
						else ret(E_INVALID_MARGINS);
					}
				}
				else
				{
					if (*token == 'l')		{ target = &(client.left);	continue; }
					if (*token == 't')		{ target = &(client.top);	continue; }
					if (*token == 'r')		{ target = &(client.right);	continue; }
					if (*token == 'b')		{ target = &(client.bottom);continue; }
					ret(E_INVALID_MARGINS);
				}
			} while (*d);
			pb->margins = client;
			GetClientRect(pb->parent,&client);
			reduce_rect(&client,&pb->margins);
			ret(SUCCEEDED(pb->pOleInPlaceObject->SetObjectRects(&client,&client)) ? SOK : E_FAILED);
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//navigate back
	int WINAPI back(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0) ret(SUCCEEDED(browsers[i]->pWebBrowser2->GoBack()) ? SOK : E_FAILED);
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//navigate home
	int WINAPI home(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0) ret(SUCCEEDED(browsers[i]->pWebBrowser2->GoHome()) ? SOK : E_FAILED);
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//navigate forward
	int WINAPI forward(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0) ret(SUCCEEDED(browsers[i]->pWebBrowser2->GoForward()) ? SOK : E_FAILED);
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//search
	int WINAPI search(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0) ret(SUCCEEDED(browsers[i]->pWebBrowser2->GoSearch()) ? SOK : E_FAILED);
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//reload page
	int WINAPI refresh(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0) ret(SUCCEEDED(browsers[i]->pWebBrowser2->Refresh()) ? SOK : E_FAILED);
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//stop
	int WINAPI stop(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0) ret(SUCCEEDED(browsers[i]->pWebBrowser2->Stop()) ? SOK : E_FAILED);
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//location name
	int WINAPI name(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0)
		{
			BSTR str;
			if(FAILED(browsers[i]->pWebBrowser2->get_LocationName(&str))) ret(E_FAILED);
			wsprintf(data,"%ws",str);
			SysFreeString(str);
			return 3;
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//location URL
	int WINAPI url(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0)
		{
			BSTR str;
			if(FAILED(browsers[i]->pWebBrowser2->get_LocationURL(&str))) ret(E_FAILED);
			wsprintf(data,"%ws",str);
			SysFreeString(str);
			return 3;
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//find HWND from caption
	int WINAPI find(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		char find_src[4096];
		findstr = find_src;
		lstrcpy(find_src,data);
		lstrcpy(data,E_NOT_FOUND);
		EnumChildWindows(GetDesktopWindow(),enum_children,(LPARAM)data);
		return 3;
	}

	//------------------------------------------------------------------------------------------
	//get caption from HWND
	int WINAPI caption(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		HWND window = (HWND)atol(data);
		lstrcpy(data,E_NOT_FOUND);
		GetWindowText(window,data,800);
		return 3;
	}
	
	//------------------------------------------------------------------------------------------
	//determines if browser is ready
	int WINAPI ready(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		int i = find_browser(data);
		if (i >= 0)
		{
			READYSTATE ready_state;
			if (SUCCEEDED(browsers[i]->pWebBrowser2->get_ReadyState(&ready_state)))
				ret(ready_state == READYSTATE_COMPLETE ? STRUE : SFALSE);
			ret(E_FAILED);
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//print
	int WINAPI print(HWND,HWND,char *data,char*,BOOL,BOOL) { return exec_cmd(data,OLECMDID_PRINT,0); }
	
	//------------------------------------------------------------------------------------------
	//zoom: 0 = smallest fonts, 4 = biggest
	int WINAPI zoom(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		VARIANT zf;
		VariantInit(&zf);
		V_VT(&zf) = VT_I4;
		V_I4(&zf) = atol(data);
		exec_cmd(data,OLECMDID_ZOOM,&zf);
		return 3;
	}

	//------------------------------------------------------------------------------------------
	//change cursor
	int WINAPI cursor(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		HCURSOR hcur = (HCURSOR)LoadCursor(0,MAKEINTRESOURCE(atol(data)));
		if (hcur)
		{
			SetCursor(hcur);	// 32512-32516,32642-32662
			ret(SOK);
		}
		ret(E_INVALID_CURSOR);
	}

	//------------------------------------------------------------------------------------------
	//dialog control id
	int WINAPI item(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		char token[1024], *d = data;
		int dialog = 0, id = 0, *target = &dialog;
		do
		{
			get_token(token,d);
			if (*token == '-' || (*token >= '0' && *token <= '9'))
				*target = atol(token);
			else
			{
				if (*token == 'd')	{ target = &dialog; continue; }
				if (*token == 'i')	{ target = &id; continue; }
				ret(E_INVALID_WINDOW);
			}
		} while (*d);
		if (IsWindow((HWND)dialog))
		{
			HWND child = GetDlgItem((HWND)dialog,6000 + id);
			if (IsWindow(child))
			{
				ltoa(data,(int)child);
				return 3;
			}
			ret(E_INVALID_ID);
		}
		ret(E_INVALID_WINDOW);
	}
	
	//------------------------------------------------------------------------------------------
	//capture mouse input
	int WINAPI capture(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		HWND window = (HWND)atol(data);
		if (IsWindow(window))
		{
			SetCapture(window);
			ret(SOK);
		}
		ret(E_INVALID_WINDOW);
	}

	//------------------------------------------------------------------------------------------
	//release mouse input
	int WINAPI release(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		ReleaseCapture();
		ret(SOK);
	}
	
	//------------------------------------------------------------------------------------------
	//version info
	int WINAPI version(HWND,HWND,char *data,char*,BOOL,BOOL)
	{
		ret("nHTMLn 2.9 by Necroman, http://necroman.wot.net, necroman@europe.com, #mIRC @ Undernet");
	}
	
	//------------------------------------------------------------------------------------------
	void WINAPI LoadDll(LOADINFO *li)
	{
		mWnd = li->mHwnd;
		
		//create file mapping
		hFileMap = CreateFileMapping(INVALID_HANDLE_VALUE,0,PAGE_READWRITE,0,0x4000,"mIRC");
		mData = (LPSTR)MapViewOfFile(hFileMap,FILE_MAP_ALL_ACCESS,0,0,0);
		
		//initialize CLE
		OleInitialize(0);
		
		//get IClassFactory* for WebBrowser
		CoGetClassObject(CLSID_WebBrowser,CLSCTX_INPROC_SERVER,0,IID_IClassFactory,(void**)&pClassFactory);
	}
	
	//------------------------------------------------------------------------------------------
	int WINAPI UnloadDll(int timeout)
	{
		if (!timeout)
		{
			//destroy browsers
			for (int i = cnt; i--;) delete browsers[i];
			fr(browsers);
			
			RELEASE(pClassFactory);
			
			//shutdown OLE
			OleUninitialize();
			
			//close file mapping
			UnmapViewOfFile(mData);
			CloseHandle(hFileMap);
		}
		return 0;
	}
}